<?php

namespace App\Commands;

use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;

class MigrateCV extends BaseCommand
{
    protected $group       = 'Database';
    protected $name        = 'migrate:cv';
    protected $description = 'Migrate CV data from Putri Anggriyani to database';

    public function run(array $params)
    {
        CLI::write('Starting CV migration...', 'green');
        
        try {
            // Run the seeder
            $seeder = \Config\Database::seeder();
            $seeder->call('CVDataSeeder');
            
            CLI::write('✓ CV data migrated successfully!', 'green');
            CLI::write('Data yang telah dimigrasi:', 'yellow');
            CLI::write('- Biodata: Putri Anggriyani', 'white');
            CLI::write('- Pendidikan: 1 record', 'white');
            CLI::write('- Pengalaman Kerja: 2 records', 'white');
            CLI::write('- Project: 9 records', 'white');
            CLI::write('- Organisasi: 1 record', 'white');
            CLI::write('- Pelatihan/Sertifikat: 9 records', 'white');
            CLI::write('- Aktivitas/Skills: 3 records', 'white');
            
        } catch (\Exception $e) {
            CLI::write('✗ Migration failed: ' . $e->getMessage(), 'red');
        }
    }
}